#include <stdio.h>
#include <math.h>       // tanh֐g߂ɕKv
#include "params.h"     // PythonŐwb_t@Cǂݍ

// O[oϐ: Uo[̏ԃxNg (l͑S0)
float reservoir_state[N_NEURONS] = {0};

// --- ֐`: Uo[̏ԂXV ---
// Pythonł x = tanh(W_in*u + W_res*x) CŎ
void update_reservoir(float input_val) {
    float next_state[N_NEURONS]; // ̏Ԃꎞۑobt@

    for (int i = 0; i < N_NEURONS; i++) {
        float activation = 0.0f;

        // 1. ͂̊^ (W_in * u)
        activation += W_in[i] * input_val;

        // 2. Uo[̔ (W_res * x_prev)
        // W_res 1zƂătbgĂ̂ŁACfbNXvZKvł
        for (int j = 0; j < N_NEURONS; j++) {
            // s (i, j) vfւ̃ANZX: i *  + j
            activation += W_res[i * N_NEURONS + j] * reservoir_state[j];
        }

        // 3. `ϊ (tanh)
        // }CRɂĂ tanhf (float) ̕ł
        next_state[i] = tanhf(activation);
    }

    // vZIAO[oϐXV
    for (int i = 0; i < N_NEURONS; i++) {
        reservoir_state[i] = next_state[i];
    }
}

// --- ֐`: _s ---
float inference(float input_val) {
    // Step 1: Uo[̏ԂXV (͑Sj[vZ)
    update_reservoir(input_val);

    // Step 2: o͌vZ (Xp[XōꂽI)
    // S50ł͂ȂAL5(N_ACTIVE_WEIGHTS)vZ܂
    float output = 0.0f;
    
    for (int i = 0; i < N_ACTIVE_WEIGHTS; i++) {
        int idx = W_out_idx[i];       // Ԗڂ̃j[
        float w = W_out_val[i];       // d݂͂炩
        
        // y =  w_i * x_i
        output += w * reservoir_state[idx];
    }
    
    return output;
}

// --- C֐: eXg ---
int main() {
    printf("=== Reservoir Computing on C (Embedded Demo) ===\n");
    printf("Total Neurons: %d\n", N_NEURONS);
    printf("Active Weights: %d (Sparse Ratio: %.1f%%)\n", 
           N_ACTIVE_WEIGHTS, (float)N_ACTIVE_WEIGHTS / N_NEURONS * 100.0);
    printf("------------------------------------------------\n");

    // eXg: Kȓ͒lēĂ݂
    // (ۂ͂ɃZT̒l܂)
    float test_input = 0.5f;

    for (int t = 0; t < 10; t++) {
        // _s
        float result = inference(test_input);
        
        printf("Step %d | Input: %.4f -> Output: %.6f\n", t, test_input, result);
        
        // ̃Xebv̂߂ɁAo͂͂ɖ߂Ă݂i[veXgj
        // Mackey-Glasŝ悤Ȏn\ł́A\l̓͂ɎgƂ܂
        test_input = result;
    }

    return 0;
}